-- Sum the annual results that have been multipled by the thermostat weight, to get the tstat weighted results.
DROP TABLE IF EXISTS sim_annual_wtd;

CREATE TABLE sim_annual_wtd(
  TechID TEXT NOT NULL,
  SizingID TEXT NOT NULL,
  BldgType TEXT NOT NULL,
  BldgVint TEXT NOT NULL,
  BldgLoc TEXT NOT NULL,
  BldgHVAC TEXT NOT NULL,
  normunit TEXT,
  numunits REAL,
  measarea NUM,
  kwh_tot REAL,
  kwh_ltg REAL,
  kwh_task REAL,
  kwh_equip REAL,
  kwh_htg REAL,
  kwh_clg REAL,
  kwh_twr REAL,
  kwh_aux REAL,
  kwh_vent REAL,
  kwh_venthtg REAL,
  kwh_ventclg REAL,
  kwh_refg REAL,
  kwh_hpsup REAL,
  kwh_shw REAL,
  kwh_ext REAL,
  thm_tot REAL,
  thm_equip REAL,
  thm_htg REAL,
  thm_shw REAL,
  deskw_ltg REAL,
  deskw_equ REAL,
  PRIMARY KEY ("TechID", "SizingID", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC")
);

INSERT INTO sim_annual_wtd
SELECT
"TechID",
"SizingID",
sim_annual_twtd."BldgType",
sim_annual_twtd."BldgVint",
sim_annual_twtd."BldgLoc",
"BldgHVAC",
normunit,
numunits,
"FloorArea"."Area" as "measarea",
(sum(kwh_tot)/numbldgs) as kwh_tot,
(sum(kwh_ltg)/numbldgs) as kwh_ltg,
(sum(kwh_task)/numbldgs) as kwh_task,
(sum(kwh_equip)/numbldgs) as kwh_equip,
(sum(kwh_htg)/numbldgs) as kwh_htg,
(sum(kwh_clg)/numbldgs) as kwh_clg,
(sum(kwh_twr)/numbldgs) as kwh_twr,
(sum(kwh_aux)/numbldgs) as kwh_aux,
(sum(kwh_vent)/numbldgs) as kwh_vent,
(sum(kwh_venthtg)/numbldgs) as kwh_venthtg,
(sum(kwh_ventclg)/numbldgs) as kwh_ventclg,
(sum(kwh_refg)/numbldgs) as kwh_refg,
(sum(kwh_hpsup)/numbldgs) as kwh_hpsup,
(sum(kwh_shw)/numbldgs) as kwh_shw,
(sum(kwh_ext)/numbldgs) as kwh_ext,
(sum(thm_tot)/numbldgs) as thm_tot,
(sum(thm_equip)/numbldgs) as thm_equip,
(sum(thm_htg)/numbldgs) as thm_htg,
(sum(thm_shw)/numbldgs) as thm_shw,
(sum(deskw_ltg)/numbldgs) as deskw_ltg,
(sum(deskw_equ)/numbldgs) as deskw_equ
from sim_annual_twtd
JOIN "NumBldgs" on "NumBldgs".bldgtype = sim_annual_twtd."BldgType"
JOIN "FloorArea" on "FloorArea"."BldgType" = sim_annual_twtd."BldgType" AND 
                    "FloorArea"."BldgVint" = sim_annual_twtd."BldgVint" AND 
                    "FloorArea"."BldgLoc" = sim_annual_twtd."BldgLoc"
GROUP BY  
"TechID",
"SizingID",
sim_annual_twtd."BldgType",
sim_annual_twtd."BldgVint",
sim_annual_twtd."BldgLoc",
"BldgHVAC",
normunit,
numunits,
numbldgs,
"FloorArea"."Area"
ORDER BY
"TechID",
"SizingID",
sim_annual_twtd."BldgType",
sim_annual_twtd."BldgVint",
sim_annual_twtd."BldgLoc",
"BldgHVAC";

-- Add primary key to table:
--ALTER TABLE "sim_annual_wtd"
--ALTER COLUMN "TechID" SET NOT NULL,
--ALTER COLUMN "SizingID" SET NOT NULL,
--ALTER COLUMN "BldgType" SET NOT NULL,
--ALTER COLUMN "BldgVint" SET NOT NULL,
--ALTER COLUMN "BldgLoc" SET NOT NULL,
--ALTER COLUMN "BldgHVAC" SET NOT NULL,
--ADD PRIMARY KEY ("TechID", "SizingID", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC");
